////////////////////////////////////////////////
//	File	:	"CSGD_ObjectManager.h"
//
//	Author	:	David Brown (DB)
//
//	Purpose	:	To contain and manage all of our game objects.
/////////////////////////////////////////////////
#pragma once
#include <vector>
using std::vector;

class CBase;

class CSGD_ObjectManager
{
private:
	vector<CBase*> m_vObjectList;

	///////////////////////////////////////////////////////////////////////////////////
	//  Function: Constructor
	//
	//  Purpose : Creates the object.
	///////////////////////////////////////////////////////////////////////////////////
	CSGD_ObjectManager(void);
	CSGD_ObjectManager(CSGD_ObjectManager&);
	CSGD_ObjectManager& operator=(CSGD_ObjectManager&);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: Destructor
	//
	//  Purpose : Destroys the object.
	///////////////////////////////////////////////////////////////////////////////////
	~CSGD_ObjectManager(void);

	static CSGD_ObjectManager* sm_pInstance;
public:
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: GetInstanec
	//
	//  Purpose : Gets an instance of the object.
	///////////////////////////////////////////////////////////////////////////////////
	static CSGD_ObjectManager* GetInstance(void);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: DeleteInstance
	//
	//  Purpose : Deletes the object.
	///////////////////////////////////////////////////////////////////////////////////
	static void DeleteInstance(void);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: UpdatesObjects
	//
	//  Purpose : Updates the objects.
	///////////////////////////////////////////////////////////////////////////////////
	void UpdateObjects(float fElapsedTime);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: CheckCollisions
	//
	//  Purpose : Checks collisions on all objects.
	///////////////////////////////////////////////////////////////////////////////////
	void CheckCollisions(void);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: RenderObjects
	//
	//  Purpose : Renders all of the objects.
	///////////////////////////////////////////////////////////////////////////////////
	void RenderObjects(void);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: AddObject
	//
	//  Purpose : Add an object to the manager.
	///////////////////////////////////////////////////////////////////////////////////
	void AddObject(CBase* pObject);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: RemoveObject
	//
	//  Purpose : Removes an object from the manager.
	///////////////////////////////////////////////////////////////////////////////////
	void RemoveObject(CBase* pObject);
	///////////////////////////////////////////////////////////////////////////////////
	//  Function: RemoveAllObjects
	//
	//  Purpose : Removes all objects from the manager.
	///////////////////////////////////////////////////////////////////////////////////
	void RemoveAllObjects(void);
};